local PPP="D:\Panlang\fd_nmr_cvd\1eggs"

use "D:\Panlang\fd_nmr_cvd\ques_bio_nmr_ep.dta"

la de rc10 12 "山东青岛 (U)"16 "黑龙江哈尔滨 (U)"26 "海南海口 (U)"36 "江苏苏州 (U)"46 "广西柳州 (U)"52 "四川成都 (R)"58 "甘肃天水 (R)"68 "河南新乡 (R)"78 "浙江嘉兴 (R)"88 "湖南长沙 (R)"
la val region_code rc10
recode region_code (12 16 58 68=0 "北方") (26 36 46 52 78 88=1 "南方"), gen(south)
gen south_urban=south*10+region_is_urban
la de us 0 "北方农村" 1 "北方城市" 10 "南方农村" 11 "南方城市"
la val south_urban us

gen age=age_at_study_date_x100/100

gen age_2g=1 if age>=60
replace age_2g=0 if age<60
la de age2 0 "<60" 1 ">=60"
la val age_2g age2

gen age_g=int(age/5)-6
replace age_g=8 if age_g==9
la de ageg 0 "<35" 1 "35-" 2 "40-" 3 "45-" 4 "50-" 5 "55-" 6 "60-" 7 "65-" 8 "70-"
la val age_g ageg

recode highest_education (0/1=0 "小学及以下") (2/5=1 "初中及以上"), gen(edu_2g)

recode household_income (min/4=0 "35000-") (nonm=1 "35000+"), gen(income_2g)

recode occupation (0 1=0 "工农业") (2 3 4 7=1 "非工农") (nonm=2 "家务/待业/下岗或其他"), gen(occu_3g)
gen occu_2g=1 if occu_3g==0
replace occu_2g=0 if occu_2g==.

recode marital_status (0=1 "已婚") (1/3=0 "未婚"), gen(mari_2g)

gen hours_since_last_ate=hours_since_last_ate_x10/10

gen fasting=1 if hours_since_last_ate>=8
replace fasting=0 if hours_since_last_ate<8

recode bmi_calc (min/18.49=1 "低体重") (18.5/23.99=2 "正常体重") (24.0/60.0=3 "超重或肥胖"), gen(obe_3g)

recode self_rated_health (min/2=0 "自评不差") (nonm=1 "自评差"), gen(self_rated_poor)

gen smk_3g=0 if smoking_category<=2
replace smk_3g=1 if smoking_category==3 & smoking_stopped_reason>0
replace smk_3g=2 if smk_3g==.
la de smk3 0 "从不/偶尔吸烟" 1 "非因病戒烟" 2 "当前吸烟/因病戒烟"
la val smk_3g smk3

gen smk_2g=1 if smk_3g==2
replace smk_2g=0 if smk_2g==.

gen smk_5g=smk_3g if smk_3g<2
replace smk_5g=2 if smk_3g==2 & cig_equiv_day<=10
replace smk_5g=3 if smk_3g==2 & cig_equiv_day>10 & cig_equiv_day<=20
replace smk_5g=4 if smk_3g==2 & cig_equiv_day>20
la de smk5 0 "从不/偶尔吸烟" 1 "非因病戒烟" 2 "<=10/d" 3 "<=20/d" 4 ">20/d"
la val smk_5g smk5

gen alc_3g=0 if alcohol_category==1 | alcohol_category==3 | alcohol_category==4
replace alc_3g=1 if alcohol_category==2 | alcohol_category==5
replace alc_3g=2 if alc_3g==.
la de alc3 0 "从不/偶尔饮酒" 1 "曾经每周饮酒" 2 "每周饮酒"
la val alc_3g alc3

gen alc_2g=1 if alc_3g==2
replace alc_2g=0 if alc_2g==.

gen alc_5g=alc_3g if alc_3g<2
replace alc_5g=2 if alc_3g==2 & is_female==0 & (total_alc_av_week_g/7)<=25
replace alc_5g=2 if alc_3g==2 & is_female==1 & (total_alc_av_week_g/7)<=15
replace alc_5g=3 if alc_3g==2 & is_female==0 & (total_alc_av_week_g/7)<=50 & (total_alc_av_week_g/7)>25
replace alc_5g=3 if alc_3g==2 & is_female==1 & (total_alc_av_week_g/7)<=30 & (total_alc_av_week_g/7)>15
replace alc_5g=4 if alc_3g==2 & is_female==0 & (total_alc_av_week_g/7)>50
replace alc_5g=4 if alc_3g==2 & is_female==1 & (total_alc_av_week_g/7)>30
la de alc5 0 "从不/偶尔饮酒" 1 "曾经每周饮酒" 2 "男<=25女<=15g/d" 3 "男<=50女<=30g/d" 4 "男>50女>30g/d"
la val alc_5g alc5

recode tea_year (0/3=0 "非每周饮茶") (4=1 "每周饮茶"), gen(tea_2g)

local fds="dairy eggs fish fresh_fruit fresh_veg meat other_staple poultry preserved_veg rice soybean wheat"
foreach fd of local fds {
	gen diet_week_`fd'=7 if diet_freq_`fd'==0
	replace diet_week_`fd'=5 if diet_freq_`fd'==1
	replace diet_week_`fd'=2 if diet_freq_`fd'==2
	replace diet_week_`fd'=0.5 if diet_freq_`fd'==3
	replace diet_week_`fd'=0 if diet_freq_`fd'==4
	la var diet_week_`fd' "`fd'"
}

gen ht=1 if hypertension_diag==1 | sbp_mean>=140 | dbp_mean>=90
replace ht=0 if ht==.

gen diabetes=1 if has_diabetes==1 | random_glucose_x10>110 | (fasting_glucose_x10>70 & fasting_glucose_x10!=.)
replace diabetes=0 if diabetes==.

gen fam_diabetes=1 if mother_diabetes==1 | father_diabetes==1 | (siblings_diabetes>=1 & siblings_diabetes!=.)
replace fam_diabetes=0 if fam_diabetes==.

gen fam_cvd=1 if mother_heart_attack==1 | father_heart_attack==1 | (siblings_heart_attack>=1 & siblings_heart_attack!=.) | mother_stroke==1 | father_stroke==1 | (siblings_stroke>=1 & siblings_stroke!=.)
replace fam_cvd=0 if fam_cvd==.

gen cvd_4g=1 if cvd_nmr=="MI case"
replace cvd_4g=2 if cvd_nmr=="IS case"
replace cvd_4g=3 if cvd_nmr=="ICH case"
replace cvd_4g=0 if cvd_4g==.
la de cvd4 0 "CT" 1 "MI" 2 "IS" 3 "ICH"
la val cvd_4g cvd4

gen cvd_2g=1 if cvd_nmr=="MI case" | cvd_nmr=="IS case" | cvd_nmr=="ICH case"
replace cvd_2g=0 if cvd_nmr=="ICH control"

gen miis_2g=1 if cvd_nmr=="MI case" | cvd_nmr=="IS case"
replace miis_2g=0 if cvd_nmr=="ICH control"

gen mi_2g=.
replace mi_2g=1 if cvd_4g==1
replace mi_2g=0 if cvd_4g==0

gen is_2g=.
replace is_2g=1 if cvd_4g==2
replace is_2g=0 if cvd_4g==0

gen ich_2g=.
replace ich_2g=1 if cvd_4g==3
replace ich_2g=0 if cvd_4g==0

gen cvd_3g=.
replace cvd_3g=0 if cvd_4g==0
replace cvd_3g=1 if cvd_4g==1
replace cvd_3g=1 if cvd_4g==2
replace cvd_3g=2 if cvd_4g==3
la de cvd3 0 "CT" 1 "MIIS" 2 "ICH"
la val cvd_3g cvd3

gen study_date1=substr(study_date,1,10)
gen study_d=date(study_date1,"YMD")
format study_d %td
drop study_date1

gen dob1=substr(dob_anon,1,10)
gen dob=date(dob1,"YMD")
format dob %td
drop dob1

ren ep_19275_combined_ep CVD_ep
ren ep_19271_combined_ep MI_ep
ren ep_19274_combined_ep IS_ep
ren ep_19277_combined_ep ICH_ep

ren ep_19275_combined_datedeveloped CVD_date0
ren ep_19271_combined_datedeveloped MI_date0
ren ep_19274_combined_datedeveloped IS_date0
ren ep_19277_combined_datedeveloped ICH_date0

local eps="CVD MI IS ICH"
foreach ep of local eps {
	gen `ep'_date1=substr(`ep'_date0,1,10)
	gen `ep'_date=date(`ep'_date1,"YMD")
	format `ep'_date %td
	drop `ep'_date1
}

save "`PPP'\use0.dta", replace
